/*******************************************************
Filename		:  co_org_table.sql
Release 		:  
SIR			:  
Description		:  Creates MetaData Cooperating Organization table and related constraints and populates data.
Author			:  Suganthi Sivakumar
Date			:  6/16/2006.
Comments		:  
**********************************************************/
set echo on 
spool co_org_table.log
/***********************************************************
Create sequences for MetaData Cooperating Organization table
************************************************************/
--drop sequence seq_md_coop;

create sequence seq_md_coop
start with 1 increment by 1 nomaxvalue nocycle cache 10;
/**********************************************
Create MetaData Cooperating Organization table
***********************************************/

--drop table md_coop;

create table md_coop
    ( pk_isn number(12,0),
      organization_id VARCHAR2(256 char) not null,
      coop_org_is_number number(12,0) not null,
      coop_organization_name VARCHAR2(256 char) not null,
      primary_contact_name VARCHAR2(256 char),
      organization_is_number number(12,0));

alter table md_coop
add constraint pk_co_org primary key (pk_isn)
using index
tablespace  STORETINDX
storage(initial 300k next 300k)
nologging;

create index icoorgid on md_coop(organization_id)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;
/* moved to after data insert

alter table md_coop
add( fk_org number(12,0));

update md_coop co
set fk_org =(select pk_isn from di_org o
              where o.organization_is_number=co.organization_is_number)
where co.organization_is_number is not null;
commit;

create index icofk on md_coop(fk_org)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;


alter table md_coop
add constraint fk_md_coop foreign key (fk_org) references di_org(pk_isn);

commit;
*/
/**********************************************************
Populate MetaData Cooperating Organization table with data.
************************************************************/
set serveroutput on
 declare
    cursor c_co_org is
    select TSMCPORG_ORG_ID,TSMCPORG_IS_NUMBER,NAME,POC_NAME,TSMORGAN_IS_NUMBER
    from storet1.tsmcporg;
    
    begin
      for c2 in c_co_org loop
    	 insert into md_coop
    	 (pk_isn,organization_id,coop_org_is_number,coop_organization_name,primary_contact_name,organization_is_number)
   	 values
   	 (seq_md_coop.nextval,c2.tsmcporg_org_id,c2.tsmcporg_is_number,c2.name,c2.poc_name,c2.tsmorgan_is_number);
     end loop;
     commit;
   end;
/

show errors;

commit;
alter table md_coop
add( fk_org number(12,0));

update md_coop co
set fk_org =(select pk_isn from di_org o
              where o.organization_is_number=co.organization_is_number)
where co.organization_is_number is not null;
commit;

create index icofk on md_coop(fk_org)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;


alter table md_coop
add constraint fk_md_coop foreign key (fk_org) references di_org(pk_isn);

commit;

alter table md_coop add SOURCE_SYSTEM VARCHAR2(256 CHAR);
alter table md_coop add SOURCE_UID NUMBER(20);
commit;

alter table md_coop modify coop_org_is_number number(12,0) null;


spool off;
